/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard.display.formatters;

import net.impactdev.impactor.api.scoreboards.display.formatters.styling.ColorFormatter;
import net.impactdev.impactor.api.scoreboards.display.formatters.styling.rgb.ColorCycle;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;

public class ColorCycleFormatter
extends ColorFormatter
implements ColorCycle {
    private final int frames;
    private final int increment;
    private final int space;
    private int phase;
    private float hue;
    private int index = 0;

    protected ColorCycleFormatter(FormatterConfig config) {
        this.frames = config.frames;
        this.increment = config.increment;
        this.phase = config.phase;
        this.space = 360 / this.frames;
    }

    @Override
    protected void advance(int length) {
        ++this.index;
    }

    @Override
    protected TextColor color(int length) {
        HSVLike hsv = HSVLike.hsvLike((float)((this.hue + (float)(this.index * this.space)) % 360.0f / 360.0f), (float)1.0f, (float)1.0f);
        return TextColor.color((HSVLike)hsv);
    }

    @Override
    public void step() {
        this.phase += this.increment;
        this.phase %= 360;
        this.hue = this.phase;
        this.index = 0;
    }

    @Override
    public int increment() {
        return this.increment;
    }

    @Override
    public int frames() {
        return this.frames;
    }

    @Override
    public int phase() {
        return this.phase;
    }

    public static final class FormatterConfig
    implements ColorCycle.Config {
        private int frames;
        private int increment;
        private int phase;

        @Override
        public ColorCycle.Config frames(int frames) {
            this.frames = frames;
            return this;
        }

        @Override
        public ColorCycle.Config phase(int phase) {
            this.phase = phase;
            return this;
        }

        @Override
        public ColorCycle.Config increment(int increment) {
            this.increment = increment;
            return this;
        }

        @Override
        public ColorCycle build() {
            return new ColorCycleFormatter(this);
        }
    }
}

